﻿//using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.Characters.ThirdPerson;
using GameUtility;

//	Summary
//		* 생성된 bottom item을 제어.

namespace Game
{
	/*
		Bottom item 관리자.
 	*/
	public class BottomController : MonoBehaviour
	{

		public float Speed;
		public float m_MovePower = 5f;
		// slide left/right 에 Player이 위치시 제어되는 힘.
	
		public float disappearTime	= 0.5f;
		// disappear bottom item의 fade out time.

		// Use this for initialization
	
		/*
			게임 scene의 bottom item들을 제어한다.

			@param Speed bottom item의 이동 속도.
	 	*/
		public static void UpdateWithOptions (float Speed)
		{
			BottomItem[] items = FindObjectsOfType (typeof(BottomItem)) as BottomItem[];

			foreach (BottomItem item in items) {
				item.Speed	= Speed;
			}
		}

		/*
			게임 scene의 bottom item의 동작을 정지한다.
		*/
		public void Pause ()
		{
			BottomItem[] items	= FindObjectsOfType (typeof(BottomItem)) as BottomItem[];

			foreach (BottomItem item in items) {
				MeshRenderer render = item.gameObject.GetComponentInChildren<MeshRenderer> ();
				render.enabled = false;

				item.Speed	= 0;

				if (item.GetComponentInChildren<AnimationScroll> () != null) {
					item.GetComponentInChildren<AnimationScroll> ().Pause ();
				}
			}
		}

		/*
			게임 scene의 bottom item의 동작을 재개한다.
	 	*/
		public void Resume (float Speed)
		{
			BottomItem[] items	= FindObjectsOfType (typeof(BottomItem)) as BottomItem[];

			foreach (BottomItem item in items) {
				MeshRenderer render = item.gameObject.GetComponentInChildren<MeshRenderer> ();
				render.enabled = true;

				item.Speed	= Speed;

				if (item.GetComponentInChildren<AnimationScroll> () != null) {
					item.GetComponentInChildren<AnimationScroll> ().Resume ();
				}
			}
		}

		/*
			게임 scene의 bottom item의 제거한다.
		*/
		public void RemoveAllVisibleItems ()
		{
			BottomItem[] items	= FindObjectsOfType (typeof(BottomItem)) as BottomItem[];

			foreach (BottomItem item in items) {
				DestroyImmediate (item.gameObject);
			}
		}

		/*
			bottom item에 Player가 위치할 시(Enter) event delegate method.

			@param item BottomItem
	 	*/
		public void onBottomEventEnter (BottomItem item)
		{
			GetComponentInParent<GameManager> ().GetPlayerRigidBody ().linearVelocity	= Vector3.zero;

			BottomType type = item.GetBottomType ();

			switch (type) {
			case BottomType.Normal:
			case BottomType.SlideLeft:
			case BottomType.SlideRight:
				// m_PlayerHealth.TakeRecovery(10);
				break;
			case BottomType.Disappear:
				item.GetComponent<AnimationFade> ().FadeOut ();
				break;
			case BottomType.Damage:
				// m_PlayerHealth.TakeDamage(50);
				break;
			default:
				break;
			}
		}

		/*
			bottom item에 Player가 위치를 유지할 때(Stay) event delegate method.

			@param item BottomItem
	 	*/
		public void onBottomEventStay (BottomItem item)
		{
			BottomType type = item.GetBottomType ();

			float forceX	= 0;
			float forceY	= 0;
			if (BottomType.SlideLeft == type) {
				forceX	= -m_MovePower;
			} else if (BottomType.SlideRight == type) {
				forceX	= m_MovePower;
			}
			
			PlayerMovement movement = GameObject.FindWithTag("Player").GetComponent<PlayerMovement>();
			movement.m_Force = forceX;
		}

		/*
			bottom item에 Player가 위치를 벗어날 시(Exit) event delegate method.

			@param item BottomItem
	 	*/
		public void onBottomEventExit (BottomItem item)
		{
			PlayerMovement movement = GameObject.FindWithTag("Player").GetComponent<PlayerMovement>();
			movement.m_Force = 0f;

			BottomType type = item.GetBottomType ();

			switch (type) {
			case BottomType.Normal:
				break;
			case BottomType.Disappear:
				break;
			case BottomType.Damage:
				break;
			case BottomType.SlideLeft:
				break;
			case BottomType.SlideRight:
				break;
			default:
				break;
			}
		}
	}
}